-- Generated by tools/imgui_upgrader/build_enums.lua

local ImGuiColorEditFlags_None             = 0
local ImGuiColorEditFlags_NoAlpha          = 2         -- 1 << 1
local ImGuiColorEditFlags_NoPicker         = 4         -- 1 << 2
local ImGuiColorEditFlags_NoOptions        = 8         -- 1 << 3
local ImGuiColorEditFlags_NoSmallPreview   = 16        -- 1 << 4
local ImGuiColorEditFlags_NoInputs         = 32        -- 1 << 5
local ImGuiColorEditFlags_NoTooltip        = 64        -- 1 << 6
local ImGuiColorEditFlags_NoLabel          = 128       -- 1 << 7
local ImGuiColorEditFlags_NoSidePreview    = 256       -- 1 << 8
local ImGuiColorEditFlags_NoDragDrop       = 512       -- 1 << 9
local ImGuiColorEditFlags_NoBorder         = 1024      -- 1 << 10
local ImGuiColorEditFlags_AlphaBar         = 65536     -- 1 << 16
local ImGuiColorEditFlags_AlphaPreview     = 131072    -- 1 << 17
local ImGuiColorEditFlags_AlphaPreviewHalf = 262144    -- 1 << 18
local ImGuiColorEditFlags_HDR              = 524288    -- 1 << 19
local ImGuiColorEditFlags_DisplayRGB       = 1048576   -- 1 << 20
local ImGuiColorEditFlags_DisplayHSV       = 2097152   -- 1 << 21
local ImGuiColorEditFlags_DisplayHex       = 4194304   -- 1 << 22
local ImGuiColorEditFlags_Uint8            = 8388608   -- 1 << 23
local ImGuiColorEditFlags_Float            = 16777216  -- 1 << 24
local ImGuiColorEditFlags_PickerHueBar     = 33554432  -- 1 << 25
local ImGuiColorEditFlags_PickerHueWheel   = 67108864  -- 1 << 26
local ImGuiColorEditFlags_InputRGB         = 134217728 -- 1 << 27
local ImGuiColorEditFlags_InputHSV         = 268435456 -- 1 << 28

imgui.ColorEditFlags = {
	None             = ImGuiColorEditFlags_None,
	NoAlpha          = ImGuiColorEditFlags_NoAlpha,          --              -- ColorEdit, ColorPicker, ColorButton: ignore Alpha component (will only read 3 components from the input pointer).
	NoPicker         = ImGuiColorEditFlags_NoPicker,         --              -- ColorEdit: disable picker when clicking on color square.
	NoOptions        = ImGuiColorEditFlags_NoOptions,        --              -- ColorEdit: disable toggling options menu when right-clicking on inputs/small preview.
	NoSmallPreview   = ImGuiColorEditFlags_NoSmallPreview,   --              -- ColorEdit, ColorPicker: disable color square preview next to the inputs. (e.g. to show only the inputs)
	NoInputs         = ImGuiColorEditFlags_NoInputs,         --              -- ColorEdit, ColorPicker: disable inputs sliders/text widgets (e.g. to show only the small preview color square).
	NoTooltip        = ImGuiColorEditFlags_NoTooltip,        --              -- ColorEdit, ColorPicker, ColorButton: disable tooltip when hovering the preview.
	NoLabel          = ImGuiColorEditFlags_NoLabel,          --              -- ColorEdit, ColorPicker: disable display of inline text label (the label is still forwarded to the tooltip and picker).
	NoSidePreview    = ImGuiColorEditFlags_NoSidePreview,    --              -- ColorPicker: disable bigger color preview on right side of the picker, use small color square preview instead.
	NoDragDrop       = ImGuiColorEditFlags_NoDragDrop,       --              -- ColorEdit: disable drag and drop target. ColorButton: disable drag and drop source.
	NoBorder         = ImGuiColorEditFlags_NoBorder,         --              -- ColorButton: disable border (which is enforced by default)
	AlphaBar         = ImGuiColorEditFlags_AlphaBar,         --              -- ColorEdit, ColorPicker: show vertical alpha bar/gradient in picker.
	AlphaPreview     = ImGuiColorEditFlags_AlphaPreview,     --              -- ColorEdit, ColorPicker, ColorButton: display preview as a transparent color over a checkerboard, instead of opaque.
	AlphaPreviewHalf = ImGuiColorEditFlags_AlphaPreviewHalf, --              -- ColorEdit, ColorPicker, ColorButton: display half opaque / half checkerboard, instead of opaque.
	HDR              = ImGuiColorEditFlags_HDR,              --              -- (WIP) ColorEdit: Currently only disable 0.0f..1.0f limits in RGBA edition (note: you probably want to use ImGuiColorEditFlags_Float flag as well).
	DisplayRGB       = ImGuiColorEditFlags_DisplayRGB,       -- [Display]    -- ColorEdit: override _display_ type among RGB/HSV/Hex. ColorPicker: select any combination using one or more of RGB/HSV/Hex.
	DisplayHSV       = ImGuiColorEditFlags_DisplayHSV,       -- [Display]    -- "
	DisplayHex       = ImGuiColorEditFlags_DisplayHex,       -- [Display]    -- "
	Uint8            = ImGuiColorEditFlags_Uint8,            -- [DataType]   -- ColorEdit, ColorPicker, ColorButton: _display_ values formatted as 0..255.
	Float            = ImGuiColorEditFlags_Float,            -- [DataType]   -- ColorEdit, ColorPicker, ColorButton: _display_ values formatted as 0.0f..1.0f floats instead of 0..255 integers. No round-trip of value via integers.
	PickerHueBar     = ImGuiColorEditFlags_PickerHueBar,     -- [Picker]     -- ColorPicker: bar for Hue, rectangle for Sat/Value.
	PickerHueWheel   = ImGuiColorEditFlags_PickerHueWheel,   -- [Picker]     -- ColorPicker: wheel for Hue, triangle for Sat/Value.
	InputRGB         = ImGuiColorEditFlags_InputRGB,         -- [Input]      -- ColorEdit, ColorPicker: input and output data in RGB format.
	InputHSV         = ImGuiColorEditFlags_InputHSV,         -- [Input]      -- ColorEdit, ColorPicker: input and output data in HSV format.
}
